package music;

import java.io.*;

/**
 * Write a description of class Song here.
 * 
 * @author (your name) 
 * @version (a version number or a date)
 */

public class Song implements Serializable{
    
    /**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private static String description;
    
    private String title;
    private Author author;
    private int year;
    public int duration;
    
    static {
        description = "A nice piece of music";
    }
    
    public Song(String title, Author author, int year, String description) {
        this.title = title;
        this.author = author;
        this.year = year;
        this.description = description;
    }
    
    public Song(String title, Author author, int year) {
        this.title = title;
        this.author = author;
        this.year = year;
    }
    
    public Song(String title) {
        this.title = title;
    }
    
//     public Song() {
    public Song() {
    }
    
    public void display() {
        System.out.println(
            "title: " + '\"' + this.title + '\"' + '\n' +
            "author: " + this.author.getName() + '\n' +
            "year: " + this.year);
    }
    
    public void setTitle(String title) {
        this.title = title;
    }
    
    public String getTitle() {
        return this.title;
    }
    
    public void setAuthor(Author author) {
        this.author = author;
    }
    
    public Author getAuthor() {
        return this.author;
    }
    
    public void setYear(int year) {
        this.year = year;
    }
    
    public int getYear() {
        return this.year;
    }
    
    public void setDescription(String description) {
        this.description = description;
    }
    
    public String getDescription() {
        return this.description;
    }
    
    public void serialize(String fileName){
    	try (ObjectOutputStream out = 
				new ObjectOutputStream(
					new BufferedOutputStream(
						new FileOutputStream(fileName)))){
			
			out.writeObject(this);
			
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
    	
    }
    
    public static Song deserialize (String fileName){
    	Song s = null;
    	try(ObjectInputStream in = 
    		new ObjectInputStream(new BufferedInputStream(
    				new FileInputStream(fileName)))){
    		
    		s = (Song) in.readObject();
    	}catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}catch (ClassNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
    	
    	return s;
    	
    	
    }
    
}
